﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content;

namespace CashierCrisis.Graphs
{
    public class GraphVisualizer
    {
        private Texture2D _texture;
        private SparseGraph<PathNode, GraphEdge> _graph;

        public GraphVisualizer(ContentManager content, SparseGraph<PathNode, GraphEdge> graph)
        {
            _graph = graph;
            _texture = content.Load<Texture2D>("Sprites//node");
        }

        public void Draw(SpriteBatch spriteBatch)
        {
            DrawNodes(spriteBatch);
        }

        public void DrawNodes(SpriteBatch spriteBatch)
        {
            
            for (int i = 0; i < _graph.Nodes.Count; i++)
            {
                if (_graph.Nodes[i].Index != GraphNode.InvalidNodeIndex)
                {
                    spriteBatch.Draw(_texture, _graph.Nodes[i].Position, Color.White);
                }
            }
         
        }

    }
}
